<?php

session_start();
header('Content-Type: application/json');

require 'vendor/autoload.php';

use RouterOS\Client;
use RouterOS\Query;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        if (!isset($_SESSION['host']) || !isset($_SESSION['user']) || !isset($_SESSION['pass'])) {
             throw new Exception("Not authenticated");
        }

        $client = new Client([
            'host' => $_SESSION['host'],
            'user' => $_SESSION['user'],
            'pass' => $_SESSION['pass'],
            'port' => isset($_SESSION['port']) ? intval($_SESSION['port']) : 8728,
        ]);

        // Construct the RouterOS Query
        $query = (new Query('/tool/netwatch/set'))
            ->equal('.id', $_POST['id'])
            ->equal('name', $_POST['name'])
            ->equal('comment', '{"parent":"' . $_POST['parent'] . '"}') // Updating the JSON comment for hierarchy
            ->equal('host', $_POST['host'])
            ->equal('down-script', $_POST['down-script'])
            ->equal('up-script', $_POST['up-script'])
            ;

        $response = $client->query($query)->read();
        
        // Check for RouterOS errors (!trap)
        if (isset($response['!trap'])) {
             throw new Exception($response['!trap'][0]['message']);
        }

        echo json_encode(["status" => "success", "data" => $response]);

    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(["error" => true, "message" => $e->getMessage()]);
    }
} else {
    http_response_code(405);
    echo json_encode(["error" => true, "message" => "Method not allowed"]);
}