<?php

session_start();
header('Content-Type: application/json');

require 'vendor/autoload.php';

use RouterOS\Client;
use RouterOS\Query;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        if (!isset($_SESSION['host']) || !isset($_SESSION['user']) || !isset($_SESSION['pass'])) {
             throw new Exception("Not authenticated");
        }

        $client = new Client([
            'host' => $_SESSION['host'],
            'user' => $_SESSION['user'],
            'pass' => $_SESSION['pass'],
            'port' => isset($_SESSION['port']) ? intval($_SESSION['port']) : 8728,
        ]);

        $query = (new Query('/tool/netwatch/add'))
            ->equal('type', 'simple')
            ->equal('name', $_POST['name'])
            ->equal('comment', '{"parent":"' . $_POST['parent'] . '"}') // Fixed syntax here
            ->equal('host', $_POST['host'])
            ->equal('interval', '90')
            ->equal('timeout', '45')
            ->equal('down-script', $_POST['down-script'])
            ->equal('up-script', $_POST['up-script'])
            ->equal('start-delay', '0')
            ->equal('startup-delay', '120')
            ;

        $response = $client->query($query)->read();
        
        // RouterOS API returns an array. If it has 'ret' or is empty, it usually means success for 'add'.
        // If it returns !trap, it's an error.
        if (isset($response['!trap'])) {
             throw new Exception($response['!trap'][0]['message']);
        }

        echo json_encode(["status" => "success", "data" => $response]);

    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(["error" => true, "message" => $e->getMessage()]);
    }
} else {
    http_response_code(405);
    echo json_encode(["error" => true, "message" => "Method not allowed"]);
}