<?php
// api.php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type");

$file = 'data.json';

// --- 1. Helper: Load Data ---
function loadJsonData($file) {
    if (!file_exists($file)) {
        return ["packages" => [], "clients" => [], "billings" => [], "users" => []];
    }
    return json_decode(file_get_contents($file), true);
}

// --- 2. Input Handling ---
$method = $_SERVER['REQUEST_METHOD'];
$action = $_GET['action'] ?? '';
$data = loadJsonData($file);

// --- 3. Handle Login (POST) ---
if ($method === 'POST' && $action === 'login') {
    $input = json_decode(file_get_contents('php://input'), true);
    $email = $input['email'] ?? '';
    $password = $input['password'] ?? '';

    foreach ($data['users'] as $user) {
        if ($user['email'] === $email && $user['password'] === $password) {
            unset($user['password']);
            echo json_encode(["status" => "success", "user" => $user]);
            exit;
        }
    }
    
    http_response_code(401);
    echo json_encode(["status" => "error", "message" => "Invalid credentials"]);
    exit;
}

// --- 4. Handle Data Fetching (GET) ---
if ($method === 'GET' && $action === 'get_data') {
    $userId = $_GET['user_id'] ?? '';
    
    $currentUser = null;
    foreach ($data['users'] as $u) {
        if ($u['id'] === $userId) {
            $currentUser = $u;
            break;
        }
    }

    if (!$currentUser) {
        http_response_code(403);
        echo json_encode(["status" => "error", "message" => "User not found"]);
        exit;
    }

    // A. ADMIN: Sees Everything
    if ($currentUser['role'] === 'admin') {
        echo json_encode($data);
        exit;
    }

    // B. CLIENT: Sees ONLY their data
    if ($currentUser['role'] === 'client') {
        $filteredData = [
            "packages" => $data['packages'], 
            "users" => [$currentUser],       
            "clients" => [],
            "billings" => []
        ];

        // NEW LOGIC: Try to find client by clientId first, fallback to name
        $linkedClientId = $currentUser['clientId'] ?? null;
        $myClientProfile = null;

        foreach ($data['clients'] as $client) {
            $isMatch = false;
            
            // Priority 1: Match by ID (Stable)
            if ($linkedClientId && $client['id'] === $linkedClientId) {
                $isMatch = true;
            } 
            // Priority 2: Match by Name (Legacy/Fallback)
            else if (!$linkedClientId && $client['name'] === $currentUser['name']) {
                $isMatch = true;
            }

            if ($isMatch) {
                $filteredData['clients'][] = $client;
                $myClientProfile = $client;
                break; 
            }
        }

        if ($myClientProfile) {
            foreach ($data['billings'] as $bill) {
                if ($bill['clientId'] === $myClientProfile['id']) {
                    $filteredData['billings'][] = $bill;
                }
            }
        }

        echo json_encode($filteredData);
        exit;
    }
}

// --- 5. Handle Save Data (POST) ---
if ($method === 'POST' && $action === 'save_data') {
    $userId = $_GET['user_id'] ?? '';
    
    $requestingUser = null;
    foreach ($data['users'] as $u) {
        if ($u['id'] === $userId) {
            $requestingUser = $u;
            break;
        }
    }

    if (!$requestingUser) {
        http_response_code(403);
        echo json_encode(["status" => "error", "message" => "User unknown"]);
        exit;
    }

    $newDataJson = file_get_contents('php://input');
    $inputData = json_decode($newDataJson, true);

    if ($inputData === null) {
        http_response_code(400);
        echo json_encode(["status" => "error", "message" => "Invalid JSON"]);
        exit;
    }

    // --- LOGIC A: ADMIN SAVE ---
    if ($requestingUser['role'] === 'admin') {
        // Admin overwrites everything (including the new clientId fields in users)
        if (file_put_contents($file, $newDataJson)) {
            echo json_encode(["status" => "success", "message" => "Data saved"]);
        } else {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Failed to write file"]);
        }
        exit;
    }

    // --- LOGIC B: CLIENT SAVE ---
    if ($requestingUser['role'] === 'client') {
        $clientUpdate = $inputData['clients'][0] ?? null;

        if (!$clientUpdate) {
            echo json_encode(["status" => "error", "message" => "No profile data sent"]);
            exit;
        }

        $foundIndex = -1;
        $linkedClientId = $requestingUser['clientId'] ?? null;

        foreach ($data['clients'] as $index => $c) {
            // NEW LOGIC: Match by ID first, then Name
            if ($linkedClientId && $c['id'] === $linkedClientId) {
                $foundIndex = $index;
                break;
            } else if (!$linkedClientId && $c['name'] === $requestingUser['name']) {
                $foundIndex = $index;
                break;
            }
        }

        if ($foundIndex !== -1) {
            $data['clients'][$foundIndex]['address'] = $clientUpdate['address'];
            $data['clients'][$foundIndex]['lat'] = $clientUpdate['lat'];
            $data['clients'][$foundIndex]['lng'] = $clientUpdate['lng'];
            $data['clients'][$foundIndex]['name'] = $clientUpdate['name'];
            
            if (file_put_contents($file, json_encode($data))) {
                echo json_encode(["status" => "success", "message" => "Profile updated"]);
            } else {
                http_response_code(500);
                echo json_encode(["status" => "error", "message" => "Failed to save profile"]);
            }
        } else {
            echo json_encode(["status" => "error", "message" => "Client profile not found"]);
        }
        exit;
    }
}

echo json_encode(["message" => "API Ready"]);
?>